/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkEventText;
import com.ibm.hwmca.fw.log.SystemEventLog;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class DataRepNotify
extends Thread {
    private static final String TRACE_MASKT = "XSRDDRAT";
    private static final String TRACE_MASKF = "XSRDDRAF";
    private static final String TRACE_MASKD = "XSRDDRAD";
    private String machineId;
    private String[] ipAddr;
    FcsServiceId id;
    private TreeMap treeData;

    DataRepNotify(String machineId, String[] ipAddr, FcsServiceId id, TreeMap treeData) {
        this.machineId = machineId;
        this.ipAddr = ipAddr;
        this.id = id;
        this.treeData = treeData;
    }

    public void run() {
        DataRepApp dataRepApp = DataRepApp.getDataRepApp();
        FcsServer server = FcsServer.getFcsServer();
        MachineId myMachine = server.getLocalMachineId();
        int j = 0;
        while (j < this.ipAddr.length) {
            block8: {
                Trace.trace(TRACE_MASKT, "DataRepNotify(" + this.machineId + " with " + this.ipAddr[j] + ")");
                try {
                    MachineId mach = new MachineId("Dummy", "", 1.0, 1, 1, new InetAddress[]{InetAddress.getByName(this.ipAddr[j])}, new boolean[]{false});
                    FcsConnection connection = FcsConnection.connect(mach, this.id);
                    Socket s = connection.getSocket();
                    ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(s.getInputStream()));
                    ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(s.getOutputStream()));
                    Object[] myObjIn = (Object[])in.readObject();
                    String inString = (String)myObjIn[0];
                    Trace.trace(TRACE_MASKT, "DataRepNotify.received:" + inString);
                    MachineId theirMachine = (MachineId)myObjIn[1];
                    if (!this.machineId.equals(theirMachine.getName())) {
                        Trace.trace(TRACE_MASKT, "DataRepNotify.received MachineId: " + theirMachine.getName() + " expected: " + this.machineId);
                        break block8;
                    }
                    Trace.trace(TRACE_MASKT, "DataRepNotify.received Machine:" + theirMachine);
                    Object[][] mylevels = new Object[this.treeData.size()][2];
                    Set keys = this.treeData.keySet();
                    int i = 0;
                    Iterator it = keys.iterator();
                    while (it.hasNext()) {
                        String dataKey = (String)it.next();
                        Object[] objArray = (Object[])this.treeData.get(dataKey);
                        mylevels[i][0] = dataKey;
                        mylevels[i][1] = objArray[0];
                        ++i;
                    }
                    out.writeObject("New Levels");
                    out.writeObject(myMachine);
                    out.writeObject(mylevels);
                    out.flush();
                    while (!inString.equals("Exit")) {
                        inString = (String)in.readObject();
                        Trace.trace(TRACE_MASKT, "DataRepNotify.received:" + inString);
                        if (!inString.equals("Get Object")) continue;
                        String customKey = (String)in.readObject();
                        if (dataRepApp.isDataRepEnabled()) {
                            Object[] obj = (Object[])this.treeData.get(customKey);
                            if (obj != null) {
                                out.writeObject("Obj Found");
                                out.writeObject(obj[3]);
                                out.writeObject(obj[0]);
                                out.flush();
                                String[] substData = new String[]{theirMachine.getName(), this.ipAddr[j], dataRepApp.getCustomDataName(customKey), ((Long)obj[0]).toString()};
                                FrameworkEventText fet = new FrameworkEventText(885, substData);
                                new SystemEventLog(fet, "CustDataLan").log();
                                continue;
                            }
                            out.writeObject("Obj Not Found");
                            out.flush();
                            continue;
                        }
                        out.writeObject("Disabled");
                        out.flush();
                    }
                    s.close();
                    break;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "DataRepNotify.exception " + e);
                    Trace.trace(TRACE_MASKT, e);
                }
            }
            ++j;
        }
    }
}

